-- Source Code Update Script -- v1.2 -----------------------------
IF EXISTS (SELECT 1 FROM INFORMATION_SCHEMA.TABLES WHERE [TABLE_SCHEMA] = 'dbo' AND [TABLE_NAME] = 'asiMappings' AND [TABLE_TYPE] <> 'VIEW')
    DROP TABLE [dbo].[asiMappings] ;

CREATE TABLE [dbo].[asiMappings]([SOURCE_CODE] varchar(40) COLLATE DATABASE_DEFAULT, [Campaign] varchar(10) COLLATE DATABASE_DEFAULT, [SourceCode] varchar(40) COLLATE DATABASE_DEFAULT);

---------------------------------------------------------------------------------------
-- This block needs to be updated with the data from the Updates tab of the 
-- SourceCodesReview Excel workbook after it has been populated according to the 
-- details in the readme file.
---------------------------------------------------------------------------------------
INSERT [dbo].[asiMappings]([SOURCE_CODE], [Campaign], [SourceCode]) 
VALUES 

-- <Paste Here>

;
 

-- -- ***DEBUG*** 
--SELECT * FROM [dbo].[asiMappings];

-------------------------------------------------------------------
-- The following portions of the script will generate SQL to update 
-- all instances of the original SOURCE_CODE with the 
-- script. 
-------------------------------------------------------------------
BEGIN
    CREATE TABLE #asiMappedTables([TABLE_SCHEMA] sysname NOT NULL, [TABLE_NAME] sysname NOT NULL, [RefOrigTransNum] bit, [HasCampaign] bit);

    WITH tablesWithBoth AS (
    SELECT t.[TABLE_NAME], t.[TABLE_SCHEMA] 
      FROM INFORMATION_SCHEMA.COLUMNS c1
            INNER JOIN INFORMATION_SCHEMA.COLUMNS c2 on c1.[TABLE_NAME] = c2.[TABLE_NAME] AND c1.[TABLE_SCHEMA] = c2.[TABLE_SCHEMA]
            INNER JOIN INFORMATION_SCHEMA.TABLES t ON c1.[TABLE_NAME] = t.[TABLE_NAME] AND c1.[TABLE_SCHEMA] = t.[TABLE_SCHEMA]
     WHERE CHARINDEX('SOURCE_CODE', c1.[COLUMN_NAME]) = 1
       AND CHARINDEX('CAMPAIGN', c2.[COLUMN_NAME]) > 0
       AND t.[TABLE_TYPE] <> 'VIEW'
       AND t.[TABLE_NAME] NOT IN ('asiMappings', 'Source_Codes')
    )
    , tablesWithOnlySourceCode AS (
    SELECT t.[TABLE_NAME], t.[TABLE_SCHEMA] 
      FROM INFORMATION_SCHEMA.COLUMNS c1
            LEFT OUTER JOIN INFORMATION_SCHEMA.COLUMNS c2 on c1.[TABLE_NAME] = c2.[TABLE_NAME] AND c1.[TABLE_SCHEMA] = c2.[TABLE_SCHEMA] AND CHARINDEX('CAMPAIGN', c2.[COLUMN_NAME]) > 0
            INNER JOIN INFORMATION_SCHEMA.TABLES t ON c1.[TABLE_NAME] = t.[TABLE_NAME] AND c1.[TABLE_SCHEMA] = t.[TABLE_SCHEMA]
     WHERE CHARINDEX('SOURCE_CODE', c1.[COLUMN_NAME]) = 1
       AND t.[TABLE_TYPE] <> 'VIEW'
       AND c2.[TABLE_NAME] IS NULL
       AND c1.[TABLE_NAME] NOT IN ('Orders','Invoice')
    )
    , addOrdersInvoice AS (
    SELECT t.[TABLE_NAME], t.[TABLE_SCHEMA] 
      FROM INFORMATION_SCHEMA.COLUMNS c1
            LEFT OUTER JOIN INFORMATION_SCHEMA.COLUMNS c2 on c1.[TABLE_NAME] = c2.[TABLE_NAME] AND c1.[TABLE_SCHEMA] = c2.[TABLE_SCHEMA] AND CHARINDEX('CAMPAIGN', c2.[COLUMN_NAME]) > 0
            INNER JOIN INFORMATION_SCHEMA.TABLES t ON c1.[TABLE_NAME] = t.[TABLE_NAME] AND c1.[TABLE_SCHEMA] = t.[TABLE_SCHEMA]
     WHERE CHARINDEX('SOURCE_CODE', c1.[COLUMN_NAME]) = 1
       AND t.[TABLE_TYPE] <> 'VIEW'
       AND c2.[TABLE_NAME] IS NULL
       AND c1.[TABLE_NAME] IN ('Orders','Invoice')
    )
    INSERT #asiMappedTables([TABLE_SCHEMA], [TABLE_NAME], [RefOrigTransNum], [HasCampaign])
    SELECT [TABLE_SCHEMA],
           [TABLE_NAME], 
           0,
           1
      FROM tablesWithBoth
    UNION 
    SELECT [TABLE_SCHEMA],
           [TABLE_NAME], 
           0,
           0
      FROM tablesWithOnlySourceCode
    UNION 
    SELECT [TABLE_SCHEMA],
           [TABLE_NAME], 
           1,
           0
      FROM addOrdersInvoice;

    -- -- ***DEBUG*** 
    --SELECT * FROM #asiMappedTables;

    DECLARE @sql nvarchar(max);

    SELECT @sql = N'';

    SELECT @sql = @sql + N'UPDATE t SET t.[SOURCE_CODE] = m.[SourceCode] FROM [' + mt.[TABLE_SCHEMA] + N'].[' + mt.[TABLE_NAME] + N'] t INNER JOIN [dbo].[asiMappings] m ON t.[SOURCE_CODE] = m.[SOURCE_CODE] INNER JOIN [dbo].[Trans] tr ON t.[ORIGINATING_TRANS_NUM] = tr.[TRANS_NUMBER] AND t.[SOURCE_CODE] = tr.[SOURCE_CODE] AND m.[Campaign] = tr.[CAMPAIGN_CODE];'
      FROM #asiMappedTables mt
     WHERE mt.[RefOrigTransNum] = 1;

    SELECT @sql = @sql + N'UPDATE t SET t.[SOURCE_CODE] = m.[SourceCode], t.[CAMPAIGN_CODE] = m.[Campaign] FROM [' + mt.[TABLE_SCHEMA] + N'].[' + mt.[TABLE_NAME] + N'] t INNER JOIN [dbo].[asiMappings] m ON t.[SOURCE_CODE] = m.[SOURCE_CODE] AND (t.[CAMPAIGN_CODE] = m.[Campaign] OR (t.[CAMPAIGN_CODE] = '''' AND m.[Campaign] = ''Default'')); '
      FROM #asiMappedTables mt
     WHERE mt.[RefOrigTransNum] = 0
       AND mt.[HasCampaign] = 1;

    SELECT @sql = @sql + N'UPDATE t SET t.[SOURCE_CODE] = m.[SourceCode] FROM [' + mt.[TABLE_SCHEMA] + N'].[' + mt.[TABLE_NAME] + N'] t INNER JOIN [dbo].[asiMappings] m ON t.[SOURCE_CODE] = m.[SOURCE_CODE] AND m.[Campaign] = ''Default''; '
      FROM #asiMappedTables mt
     WHERE mt.[RefOrigTransNum] = 0
       AND mt.[HasCampaign] = 0;

    EXEC(@sql);

      -- -- ***DEBUG*** 
        --PRINT @sql; 
        --PRINT SUBSTRING(@sql, 4000, 4000);
        --PRINT SUBSTRING(@sql, 8000, 4000);
        --PRINT SUBSTRING(@sql, 12000, 4000);
        --PRINT SUBSTRING(@sql, 16000, 4000);
        --PRINT SUBSTRING(@sql, 20000, 4000);
        --PRINT SUBSTRING(@sql, 24000, 4000);
        --PRINT SUBSTRING(@sql, 28000, 4000);
        --PRINT SUBSTRING(@sql, 32000, 4000);
        --PRINT SUBSTRING(@sql, 36000, 4000);
        --PRINT SUBSTRING(@sql, 40000, 4000);
        --PRINT SUBSTRING(@sql, 44000, 4000);
        --PRINT SUBSTRING(@sql, 48000, 4000);
        --PRINT SUBSTRING(@sql, 52000, 4000);
        --PRINT SUBSTRING(@sql, 56000, 4000);
        --PRINT SUBSTRING(@sql, 60000, 4000);
        --PRINT SUBSTRING(@sql, 64000, 4000);
        --PRINT SUBSTRING(@sql, 68000, 4000);
        --PRINT SUBSTRING(@sql, 72000, 4000);
        --PRINT SUBSTRING(@sql, 76000, 4000);
        --PRINT SUBSTRING(@sql, 80000, 4000);
        --PRINT SUBSTRING(@sql, 84000, 4000);
        --PRINT SUBSTRING(@sql, 88000, 4000);
        --PRINT SUBSTRING(@sql, 92000, 4000);
        --PRINT SUBSTRING(@sql, 96000, 4000);
        --PRINT SUBSTRING(@sql, 100000, 4000);
        --PRINT SUBSTRING(@sql, 104000, 4000);
        --PRINT SUBSTRING(@sql, 108000, 4000);
        --PRINT SUBSTRING(@sql, 112000, 4000);
        --PRINT SUBSTRING(@sql, 116000, 4000);
        --PRINT SUBSTRING(@sql, 120000, 4000);
        --PRINT SUBSTRING(@sql, 124000, 4000);
        --PRINT SUBSTRING(@sql, 128000, 4000);
        --PRINT SUBSTRING(@sql, 132000, 4000);
        --PRINT SUBSTRING(@sql, 136000, 4000);
        --PRINT SUBSTRING(@sql, 140000, 4000);
        --PRINT SUBSTRING(@sql, 144000, 4000);
        --PRINT SUBSTRING(@sql, 148000, 4000);
        --PRINT SUBSTRING(@sql, 152000, 4000);
        --PRINT SUBSTRING(@sql, 156000, 4000);

END;

DROP TABLE #asiMappedTables;

IF EXISTS (SELECT 1 FROM INFORMATION_SCHEMA.TABLES WHERE [TABLE_SCHEMA] = 'dbo' AND [TABLE_NAME] = 'asiMappings' AND [TABLE_TYPE] <> 'VIEW')
    DROP TABLE [dbo].[asiMappings] ;

GO